#!/usr/bin/env python3
import pickle
import numpy as np
import pandas as pd

class MigrationModel:
    def __init__(self, df, features=None, targets=None):
        self.df = df
        self.features = features
        self.targets = targets
        self.__cv_result = None
        self.__regr = None
        self.__X_scaler = None
        self.__Y_scaler = None

    def set_features(self, features):
        self.features = features

    def set_targets(self, targets):
        self.targets = targets

    def cross_validation(self, n_splits=10):
        """
        Validate the model using k-fold corss validation.
        """
        pass

    def preprocess_x(self, df):
        df = df.copy()
        for col in ['cycles', 'instructions', 'cache_references', 'cache_misses']:
            if col not in df:
                continue
            df[col] = np.log(df[col] / 1000000)

        columns = []
        if type(df) == pd.DataFrame:
            columns = df.columns
        elif type(df) == pd.Series:
            columns = df.index
        for col in columns:
            if 'minmax' not in col:
                continue
            df[col] -= 1.0
            df[col] *= 1000000
            df[col] = df[col].astype('int32')
            # print(df[col])

        for col in self.features:
            try:
                if col in ['cycles', 'instructions', 'cache_references', 'cache_misses', 'postcopy_start_iteration']:
                    continue
                if col in ['xbzrle_cache_size', 'max_postcopy_bandwidth', 'max_bandwidth']:
                    df[col] = np.log(df[col] / 2**20 + 1)
                else:
                    df[col] = np.log(df[col])
            except:
                print(col, df[col])
                import sys
                sys.exit(1)

        return df

    def preprocess_y(self, df):
        return df


    def fit(self):
        pass

    def predict(self):
        pass

    def dump(self, path):
        with open(path, 'wb') as f:
            pickle.dump(self, f, pickle.HIGHEST_PROTOCOL)